<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invite extends Model 
{

    protected $table = 'invites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('evenement_id', 'table_id', 'invite_id', 'slug', 'qr_code', 'nom', 'prenom', 'sexe', 'telephone', 'email', 'lien', 'type', 'statut_invitation', 'statut');
    protected $visible = array('evenement_id', 'table_id', 'invite_id', 'slug', 'qr_code', 'nom', 'prenom', 'sexe', 'telephone', 'email', 'lien', 'type', 'statut_invitation', 'statut');

    public function inviteReponseQuestion()
    {
        return $this->hasMany('App\Models\InviteReponseQuestion', 'invite_id');
    }

    public function evenement()
    {
        return $this->belongsTo('App\Models\Evenement', 'evenement_id');
    }

    public function cavalier()
    {
        return $this->hasMany('App\Models\Invite', 'invite_id');
    }

    public function invite()
    {
        return $this->belongsTo('App\Models\Invite', 'invite_id');
    }

    public function temoignage()
    {
        return $this->hasMany('App\Models\Temoignage', 'invite_id');
    }

    public function invitesTables()
    {
        return $this->hasMany('App\Models\InviteTable', 'invite_id');
    }

    public function cadeaux()
    {
        return $this->hasMany('App\Models\Cadeau', 'invite_id');
    }

    public function ceremonies()
    {
        return $this->belongsToMany('App\Models\Ceremonie', 'invite_ceremonie', 'invite_id', 'ceremonie_id');
    }

    public function userCeremonies()
    {
        return $this->hasMany('App\Models\InviteCeremonie', 'invite_id');
    }

}